// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'ZylSerialPort.pas' rev: 5.00

#ifndef ZylSerialPortHPP
#define ZylSerialPortHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Registry.hpp>	// Pascal unit
#include <Math.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Zylserialport
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TCommPort { spNone, spCOM1, spCOM2, spCOM3, spCOM4, spCOM5, spCOM6, spCOM7, spCOM8, spCOM9, spCOM10, 
	spCOM11, spCOM12, spCOM13, spCOM14, spCOM15, spCOM16, spCOM17, spCOM18, spCOM19, spCOM20, spCOM21, 
	spCOM22, spCOM23, spCOM24, spCOM25, spCOM26, spCOM27, spCOM28, spCOM29, spCOM30, spCOM31, spCOM32, 
	spCOM33, spCOM34, spCOM35, spCOM36, spCOM37, spCOM38, spCOM39, spCOM40, spCOM41, spCOM42, spCOM43, 
	spCOM44, spCOM45, spCOM46, spCOM47, spCOM48, spCOM49, spCOM50 };
#pragma option pop

typedef Set<TCommPort, spNone, spCOM50>  TCommPortSet;

#pragma option push -b-
enum TBaudRate { br000110, br000300, br000600, br001200, br002400, br004800, br009600, br014400, br019200, 
	br038400, br056000, br057600, br115200, br128000, br256000 };
#pragma option pop

#pragma option push -b-
enum TStopBits { sb1Bit, sb1_5Bits, sb2Bits };
#pragma option pop

#pragma option push -b-
enum TDataWidth { dw5Bits, dw6Bits, dw7Bits, dw8Bits };
#pragma option pop

#pragma option push -b-
enum TParityBits { pbNone, pbOdd, pbEven, pbMark, pbSpace };
#pragma option pop

#pragma option push -b-
enum THwFlowControl { hfNONE, hfRTS, hfRTSCTS };
#pragma option pop

#pragma option push -b-
enum TSwFlowControl { sfNONE, sfXONXOFF };
#pragma option pop

#pragma option push -b-
enum TLineStatus { lsCTS, lsDSR, lsRING, lsCD };
#pragma option pop

typedef Set<TLineStatus, lsCTS, lsCD>  TLineStatusSet;

typedef void __fastcall (__closure *TConnectEvent)(System::TObject* Sender, TCommPort Port);

typedef void __fastcall (__closure *TSendReceiveEvent)(System::TObject* Sender, AnsiString Buffer);

typedef void __fastcall (__closure *TLineStatusEvent)(System::TObject* Sender, TLineStatusSet LineStatus
	);

class DELPHICLASS TZylSerialPort;
class PASCALIMPLEMENTATION TZylSerialPort : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	AnsiString FPort;
	int FBaudRate;
	Byte FDataWidth;
	Byte FParity;
	Byte FStopBits;
	bool FEnableDTROnOpen;
	bool FEnableRTSOnOpen;
	THwFlowControl FHwFlowControl;
	TSwFlowControl FSwFlowControl;
	AnsiString FReadBuffer;
	TLineStatusSet FLineStatus;
	int FReadIntervalTimeout;
	int FReadTotalTimeoutMultiplier;
	int FReadTotalTimeoutConstant;
	int FWriteTotalTimeoutMultiplier;
	int FWriteTotalTimeoutConstant;
	Classes::TThreadPriority FPriority;
	unsigned FDelay;
	unsigned FInputBuffer;
	unsigned FOutputBuffer;
	double FVersion;
	Classes::TThread* ComThread;
	TCommPort ConnectedTo;
	bool FRegistered;
	bool FIsSending;
	bool FIsReceiving;
	bool FNeedSynchronization;
	TSendReceiveEvent FOnReceive;
	TSendReceiveEvent FOnSend;
	TLineStatusEvent FOnLineStatusChange;
	TConnectEvent FOnConnect;
	TConnectEvent FOnDisconnect;
	TCommPort __fastcall GetCommPort(void);
	void __fastcall SetCommPort(TCommPort Value);
	TBaudRate __fastcall GetBaudRate(void);
	void __fastcall SetBaudRate(TBaudRate Value);
	TDataWidth __fastcall GetDataWidth(void);
	void __fastcall SetDataWidth(TDataWidth Value);
	TStopBits __fastcall GetStopBits(void);
	void __fastcall SetStopBits(TStopBits Value);
	TParityBits __fastcall GetParity(void);
	void __fastcall SetParity(TParityBits Value);
	void __fastcall SetEnableDTROnOpen(bool Value);
	void __fastcall SetEnableRTSOnOpen(bool Value);
	void __fastcall SetHwFlowControl(THwFlowControl Value);
	void __fastcall SetSwFlowControl(TSwFlowControl Value);
	void __fastcall SetPriority(Classes::TThreadPriority Value);
	void __fastcall SetInputBuffer(unsigned Value);
	void __fastcall SetOutputBuffer(unsigned Value);
	bool __fastcall SetDCBState(unsigned ComDevice);
	bool __fastcall SetTimeOuts(unsigned COmDevice);
	bool __fastcall SetBuffers(unsigned ComDevice);
	TLineStatusSet __fastcall GetLineStatus(unsigned ComDevice);
	bool __fastcall RunningInTheIDE(void);
	
public:
	__property bool IsSending = {read=FIsSending, default=0};
	__property bool IsReceiving = {read=FIsReceiving, default=0};
	__property bool NeedSynchronization = {read=FNeedSynchronization, write=FNeedSynchronization, default=1
		};
	__property double Version = {read=FVersion};
	__fastcall virtual TZylSerialPort(Classes::TComponent* AOwner);
	__fastcall virtual ~TZylSerialPort(void);
	void __fastcall Open(void);
	void __fastcall Close(void);
	TCommPort __fastcall IsConnected(void);
	TCommPort __fastcall StringToCommPort(AnsiString Port);
	AnsiString __fastcall CommPortToString(TCommPort Port);
	unsigned __fastcall SendString(AnsiString str);
	unsigned __fastcall SendData(void * Data, unsigned dataSize);
	TCommPortSet __fastcall GetExistingCommPorts();
	void __fastcall SetBreak(bool OnOff);
	void __fastcall SetDTR(bool OnOff);
	void __fastcall SetRTS(bool OnOff);
	void __fastcall SetXonXoff(bool OnOff);
	void __fastcall ClearInputBuffer(void);
	void __fastcall ClearOutputBuffer(void);
	bool __fastcall GetCTS(void);
	bool __fastcall GetDSR(void);
	bool __fastcall GetRING(void);
	bool __fastcall GetCD(void);
	
__published:
	__property TCommPort Port = {read=GetCommPort, write=SetCommPort, default=2};
	__property TBaudRate BaudRate = {read=GetBaudRate, write=SetBaudRate, default=5};
	__property TDataWidth DataWidth = {read=GetDataWidth, write=SetDataWidth, default=3};
	__property TStopBits StopBits = {read=GetStopBits, write=SetStopBits, default=0};
	__property TParityBits Parity = {read=GetParity, write=SetParity, default=0};
	__property bool EnableDTROnOpen = {read=FEnableDTROnOpen, write=SetEnableDTROnOpen, default=1};
	__property bool EnableRTSOnOpen = {read=FEnableRTSOnOpen, write=SetEnableRTSOnOpen, default=1};
	__property THwFlowControl HwFlowControl = {read=FHwFlowControl, write=SetHwFlowControl, default=0};
		
	__property TSwFlowControl SwFlowControl = {read=FSwFlowControl, write=SetSwFlowControl, default=0};
		
	__property int ReadIntervalTimeout = {read=FReadIntervalTimeout, write=FReadIntervalTimeout, default=-1
		};
	__property int ReadTotalTimeoutMultiplier = {read=FReadTotalTimeoutMultiplier, write=FReadTotalTimeoutMultiplier
		, default=0};
	__property int ReadTotalTimeoutConstant = {read=FReadTotalTimeoutConstant, write=FReadTotalTimeoutConstant
		, default=0};
	__property int WriteTotalTimeoutMultiplier = {read=FWriteTotalTimeoutMultiplier, write=FWriteTotalTimeoutMultiplier
		, default=100};
	__property int WriteTotalTimeoutConstant = {read=FWriteTotalTimeoutConstant, write=FWriteTotalTimeoutConstant
		, default=1000};
	__property unsigned InputBuffer = {read=FInputBuffer, write=SetInputBuffer, default=4096};
	__property unsigned OutputBuffer = {read=FOutputBuffer, write=SetOutputBuffer, default=4096};
	__property Classes::TThreadPriority Priority = {read=FPriority, write=SetPriority, default=3};
	__property unsigned Delay = {read=FDelay, write=FDelay, default=50};
	__property TSendReceiveEvent OnReceive = {read=FOnReceive, write=FOnReceive};
	__property TSendReceiveEvent OnSend = {read=FOnSend, write=FOnSend};
	__property TLineStatusEvent OnLineStatusChange = {read=FOnLineStatusChange, write=FOnLineStatusChange
		};
	__property TConnectEvent OnConnect = {read=FOnConnect, write=FOnConnect};
	__property TConnectEvent OnDisconnect = {read=FOnDisconnect, write=FOnDisconnect};
};


class DELPHICLASS TComThread;
class PASCALIMPLEMENTATION TComThread : public Classes::TThread 
{
	typedef Classes::TThread inherited;
	
private:
	TZylSerialPort* Owner;
	
protected:
	void __fastcall DoExecuteReceive(void);
	void __fastcall DoExecuteLineStatus(void);
	void __fastcall DoExecuteConnect(void);
	void __fastcall DoExecuteDisconnect(void);
	virtual void __fastcall Execute(void);
	
public:
	unsigned ComDevice;
	__fastcall TComThread(TZylSerialPort* AOwner);
	unsigned __fastcall GetPortHandle(void);
	__fastcall virtual ~TComThread(void);
};


//-- var, const, procedure ---------------------------------------------------
static const Shortint dcb_Binary = 0x1;
static const Shortint dcb_ParityCheck = 0x2;
static const Shortint dcb_OutxCtsFlow = 0x4;
static const Shortint dcb_OutxDsrFlow = 0x8;
static const Shortint dcb_DtrControlMask = 0x30;
static const Shortint dcb_DtrControlDisable = 0x0;
static const Shortint dcb_DtrControlEnable = 0x10;
static const Shortint dcb_DtrControlHandshake = 0x20;
static const Shortint dcb_DsrSensivity = 0x40;
static const Byte dcb_TXContinueOnXoff = 0x80;
static const Word dcb_OutX = 0x100;
static const Word dcb_InX = 0x200;
static const Word dcb_ErrorChar = 0x400;
static const Word dcb_NullStrip = 0x800;
static const Word dcb_RtsControlMask = 0x3000;
static const Shortint dcb_RtsControlDisable = 0x0;
static const Word dcb_RtsControlEnable = 0x1000;
static const Word dcb_RtsControlHandshake = 0x2000;
static const Word dcb_RtsControlToggle = 0x3000;
static const Word dcb_AbortOnError = 0x4000;
static const unsigned dcb_Reserveds = 0xffff8000;
extern PACKAGE unsigned __stdcall (*_timeBeginPeriod)(unsigned period);
extern PACKAGE unsigned __stdcall (*_timeEndPeriod)(unsigned period);
extern PACKAGE void __fastcall Register(void);
extern PACKAGE void * __fastcall LinkAPI(const AnsiString module, const AnsiString functionname);

}	/* namespace Zylserialport */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Zylserialport;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// ZylSerialPort
